; Hyperlink (Subclass control & OwnerDraw control ) Example
; RobotBob (Eric Asbell)
; easbell@quanta-it.com
; http://easbell.quanta-it.com
; 2005

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; Level:        Intermediate
; Requires:     a base knowledge of Win32 api.

; I make an assumption that you know the basics of
; creating an win32 application, fundmental assembly
; and how to use win32 api documentation.
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

; What is this example about ?
; It simulates the function of a *Hyperlink*.

; There are many way to do this, each more or less
; produces the same thing. In this example we use a
; new API call (not part of the original win95)
; TrackMouseEvent. There are two calls, one of which
; is commented out. The USER32 version is availible in
; Win98+ & NT 4.0 and the COMCTL32 version is availible
; in IE 3 or greater. The easy way is to just load the
; COMCTL32 version. Or you could use LoadLibrary and
; only load the correct one based on OS version. To
; me this is ideal in this type of situation, it unsures
; the OS will not break your program. However I have omitted
; just that for clarity in this example.

; What is *Subclass* ?

; A subclass is a window or set of windows with the same
; class whose messages are intercepted and processed by
; another window procedure (or procedures) before being
; passed to the window procedure of the class.
; Or better in simple english, We hijack the damn thing :)

; What is Owner Draw ?

; On creation of our control, we specify it (in this case
; &SS_OWNERDRAW) in the CreateWindow call. We now are
; responsible for drawing the control in the message:
; &WM_DRAWITEM.

; Key Functions in this example:

; DrawTheHyperLink
; HyperLinkProc

; the call to TrackMouseEvent.
; the call to SetWindowLong.
; the process of drawing the hyperlink in the WM_DRAWITEM message.

; If you find a an error or have a question feel free to email me.
_____________________________________________________________________________________________
_____________________________________________________________________________________________

; General purpose macros:
[push | push #1 | #+1]  [pop | pop #1 | #+1]  [mov | mov #1 #2 | #+2]
[inc | inc #1 | #+1]    [dec | dec #1 | #+1]
[On | cmp #1 #3 | jn#2 M1> | #4>L | M1:]
[call | push #L>2 | call #1]
[move | push #2 | pop #1 | #+2]      ; (for mem to mem moves, for exemple)

[If | cmp #1 #3 | jn#2 I1>]
[Else_if | jmp I9> | I1: | cmp #1 #3 | jn#2 I1>]
[Else | Jmp I9> | I1:]
[End_if | I1: | I9:]

[.If | cmp #1 #3 | jn#2 J1>>]
[.Else_if | jmp J9>> | J1: | cmp #1 #3 | jn#2 j1>>]
[.Else | Jmp j9>> | j1:]
[.End_if | j1: | j9:]

[..If | cmp #1 #3 | jn#2 K1>>]
[..Else_if | jmp K9>> | K1: | cmp #1 #3 | jn#2 K1>>]
[..Else | Jmp K9>> | K1:]
[..End_if | K1: | K9:]

[...If | cmp #1 #3 | jn#2 Z1>>]
[...Else_if | jmp Z9>> | Z1: | cmp #1 #3 | jn#2 Z1>>]
[...Else | Jmp Z9>> | Z1:]
[...End_if | Z1: | Z9:]

[While | W0: | cmp #1 #3 | jn#2 W9>]
[End_While | jmp W0< | W9:]

[.While | X0: | cmp #1 #3 | jn#2 X9>>]
[.End_While | jmp X0<< | X9:]

[..While | Y0: | cmp #1 #3 | jn#2 Y9>>]
[..End_While | jmp Y0<< | Y9:]

[Do | D0:]
[Loop_Until | cmp #1 #3 | jn#2 D0<]
[Do_Loop | jmp D0<<]

[.Do | E0:]
[.Loop_Until | cmp #1 #3 | jn#2 E0<<]
[Exchange | push #1 | push #2 | pop #1 | pop #2 | #+2]
[Agree | cmp #1 #3 | j#2 A9> | #+3]
[Reject | cmp #1 #3 | j#2 A8> | #+3 | jmp A9> | A8: | ret | A9:]
_________________________________________________________________________________________
_________________________________________________________________________________________
; Proc Macros and Equates. Internal storages are:
;
; &1 <<< Size of Argument(s) (for ending Ret n, in EndP). Set by Argument(s)
; &2 <<< Size of Local (for Stack Management). Set by Local
; &3 <<< What to pop before ret. Set by Uses.

[Proc | &1=0 | &2=0 | &3= | #1 | push ebp | mov ebp esp]
[ExitP | jmp P9>>]
[Arguments | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Argument  | {#1 Arg#x} | #+1 | &1=SizeOf#x]
[Local | {#1 Local#x} | #+1 | sub esp SizeOf#x | &2=SizeOf#x]
[StrucPtrs | {#3 ebp+#2+#F} | #+2]
[Structure | {#1 ebp-&2-4} | sub esp #2+4 | mov D$#1 esp | StrucPtrs 0-&2-#2-4 #L>3]
[Uses | push #1>L | &3=pop #L>1]
[EndP | P9: | &3 | mov esp ebp | pop ebp | ret &1]

; For pointing to transmitted parameters (upper "Arg#x" fall here):
[Arg1 ebp+8    Arg2 ebp+12    Arg3 ebp+16    Arg4 ebp+20   Arg5 ebp+24
 Arg6 ebp+28   Arg7 ebp+32    Arg8 ebp+36    Arg9 ebp+40   Arg10 ebp+44]

; For pointing Local Stack declared data (upper "Local#x" fall here):
[Local1 ebp-4     Local2 ebp-8     Local3 ebp-12    Local4 ebp-16    Local5 ebp-20
 Local6 ebp-24    Local7 ebp-28    Local8 ebp-32    Local9 ebp-36    Local10 ebp-40]

; To help preventing from stack sizes' mistakes (upper "SizeOf#x" fall here):
[SizeOf1 4     SizeOf2 8     SizeOf3 12    SizeOf4 16    SizeOf5 20
 SizeOf6 24    SizeOf7 28    SizeOf8 32    SizeOf9 36    SizeOf10 40]
____________________________________________________________________________________________
____________________________________________________________________________________________
; Equates for HLL comparisons (with 'If' and friends):
[= e   < b    > a    <s l    >s g    =< be    <= be    => ae    >= ae    <> ne]
_____________________________________________________________________________________________
_____________________________________________________________________________________________

; My macros for my debug window, man I am dependant on it :)
;[OutPutDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutDec' #1 &0]
;[OutPutSignedDec | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutSignedDec' #1 &0]
;[OutPutHex | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutHex' #1 &0]
;[OutPutFloat | fld #1 | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutFloat' #1 &0 #2 #3]
;[OutPutString | &4=#1 | { &0: B$ '&4' 0 } | call 'QDEBUG.OutPutString' #1 &0]
;[OutPutError | call 'KERNEL32.GetLastError' | call 'QDEBUG.OutPutError' eax ]
;[OutPutStringLiteral | &4=#1 | { &0: B$ &4 0 } | call 'QDEBUG.OutPutStringSimple' &0 ]
;[OutPutLog | call 'QDEBUG.OutPutLogFile' #1]
____________________________________________________________________________________________

; For "GetMessage":
[FirstMessage: 0 #7]

; Window Class Structure:
[WindowClass:
 style: 3
 lpfnWndProc: MainWindowProc
 cbClsExtra: 0
 cbWndExtra: 0
 hInstance: 0
 hIcon: 0
 hCursor: 0
 hbrBackground: 1
 lpszMenuName: 0
 lpszClassName: WindowClassName]

[WindowHandle: 0   MenuHandle: 0]
[WindowClassName: B$ 'HYPERLINK' 0    WindowCaption: 'Hyperlink Example' 0]
[WindowX: 50  WindowY: 50  WindowW: 200  WindowH: 120]

____________________________________________________________________________________________

; Our Data! woohoo! it takes vey little to make me happy :)

; This holds (or will) the previous address of the button procedure.
[OldHyperlinkProc: D$ ?]

; The handle of the finger pointing cursor
[HandCursorHandle: D$ ?]

; We save a state here, "Are we hovering over the control ?"
[Hovering: D$ 0]

; Here is the FONSTRUCT sent to our static control (aka our Hyperlink)
[HyperLink_LOGFONTSTRUCT:
lfHeight: D$ 0-13
lfWidth: D$ 0
lfEscapement: D$ 0
lfOrientation: D$ 0
lfWeight: D$ 0
lfItalic: B$ 0
lfUnderline: B$ 1
lfStrikeOut: B$ 0
lfCharSet: B$ &DEFAULT_CHARSET
lfOutPrecision: B$ &OUT_DEFAULT_PRECIS
lfClipPrecision: B$ &CLIP_DEFAULT_PRECIS
lfQuality: B$ &DEFAULT_QUALITY
lfPitchAndFamily: B$ 0]
[lfFaceName: B$ 'MS Sans Serif', 0]

; This structure is for the TrackMouseEvent API call
[TRACKMOUSEEVENT:
 @cbSize: D$ 16                     ; SizeOf the struct..but its static at 16
 @dwFlags: D$ &TME_HOVER+&TME_LEAVE ; We want LEAVE and HOVER messages
 @hwndTrack: D$ 0                   ; Holds our hWnd of the window to track
 @dwHoverTime: D$ 100 ]             ; hovertime in milliseconds

; A macro to generate COLOREFs from a set of RGB numbers
; example: RGB 255 0 0
[RGB|mov al #3|shl eax 8|add al #2|shl eax 8|add al #1|and eax 0FFFFFF]

; Our Displacement table. Since the &WM_DRAWITEM returns in the
; lParam a DRAWITEMSTRUCT. We will need a (easy on the eyes) way
; to access the elements in this table.
; Since we have only one DRAWITEMSTRUCT in this table, only
; this: base+displacement is needed. Refer to the B_U_ASM.EXE->Addressing
; for more information.

[CtlTypeDis 0
 CtlIDDis 4
 itemIDDis 8
 itemActionDis 12
 itemStateDis 16
 hwndItemDis 20
 hdcDis 24
 rcItem.leftDis 28
 rcItem.topDis 32
 rcItem.rightDis 36
 rcItem.bottomDis 40
 itemDataDis 44]

; This equate is to allow us an easy reference to the hyperlink
; inside the WM_COMMAND messages
[OurHyperLink 200]

[HyperLink_handle: D$ ?]

; This is the text we are going to draw onto the hyperlink.
[BTEXT: B$ "http://www.rosasm.org" 0]
___________________________________________________________________________________________

Main:
    call 'Kernel32.GetModuleHandleA' 0 | mov D$hInstance eax
    call 'User32.LoadIconA' D$hInstance, 1 | mov D$hIcon eax
    call 'User32.LoadCursorA' 0, &IDC_ARROW | mov D$hCursor eax

    ; Load our hand cursor !
    call 'User32.LoadCursorA' 0, &IDC_HAND  | mov D$HandCursorHandle eax
    call 'User32.RegisterClassA' WindowClass

    call 'User32.CreateWindowExA' &WS_EX_CLIENTEDGE, WindowClassName, WindowCaption,
                                 &WS_OVERLAPPEDWINDOW__&WS_VISIBLE,
                                 D$WindowX, D$WindowY, D$WindowW, D$WindowH, 0,
                                 &NULL, D$hInstance, 0
    mov D$WindowHandle eax

    ; Create the static control as OwnerDraw
    ; I am cheating here a bit. I make the static control almost exactly
    ; the size of the text...so it appears to only to change upon reaching
    ; the text. I don't see the need here. A programmer would use this type
    ; of control only a few times in an app. I could be wrong, so if you need
    ; better precsion, do RECT or REGION calculations (GetCursorPos and the like)
    call 'User32.CreateWindowExA',
        0,
        {"STATIC",0},
        {"Hyperlink Example",0},
        &WS_CHILD+&WS_CLIPSIBLINGS+&WS_VISIBLE+&SS_NOTIFY+&SS_OWNERDRAW,
        16,16,130,18,
        D$WindowHandle,
        200,
        D$hInstance,
        0
    mov D$HyperLink_handle eax

   ; copy the handle into the trackmouseevent struct.
   mov eax D$HyperLink_handle
   mov D$TRACKMOUSEEVENT@hwndTrack eax

   ; We call this here to get the mouse tracking started.
   ;call 'USER32.TrackMouseEvent' TRACKMOUSEEVENT        ; Not in Win95
   call 'COMCTL32._TrackMouseEvent' TRACKMOUSEEVENT      ; Win95 with IE 3+

    ; Here is where we redirect the WindowProc that normal handles
    ; a windows messages and send it to our own. The API call return a
    ; handle to the previous Procedure, we shall save it in order to restore
    ; it before the app terminates.

    call 'USER32.SetWindowLongA' D$HyperLink_handle &GWL_WNDPROC HyperlinkProc
    mov D$OldHyperlinkProc eax

    call 'GDI32.CreateFontIndirectA' HyperLink_LOGFONTSTRUCT
    mov D$@HyperLinkFont_handle eax

    call 'User32.SendMessageA' D$HyperLink_handle  &WM_SETFONT eax &TRUE
    [@HyperLinkFont_handle: ?]

    call 'User32.ShowWindow' D$WindowHandle, &SW_SHOW
    call 'User32.UpdateWindow' D$WindowHandle

    jmp L1>

    While eax <> 0
        call 'User32.TranslateMessage' FirstMessage
        call 'User32.DispatchMessageA' FirstMessage
L1:     call 'USER32.GetMessageA' FirstMessage 0 0 0
    End_While

    call 'Kernel32.ExitProcess' &NULL

___________________________________________________________________________________________

Proc MainWindowProc:
    Arguments @Addressee @Message @wParam @lParam

    pushad

      .If D@Message = &WM_CREATE

      .Else_If D@Message = &WM_DRAWITEM
            ; Is it our hyperlink ? hmmm
            If D@wParam = OurHyperLink
                ; Yes! draw it :)
                call DrawTheHyperlink D@lParam
            End_If

       mov eax &TRUE

      .Else_If D@Message = &WM_CLOSE

        ; Now before we leave, we must set the old procedure back.
        If D$HyperLink_handle <> &NULL
            call 'USER32.SetWindowLongA' D$HyperLink_handle,
                                         &GWL_WNDPROC,
                                         D$OldHyperlinkProc
        End_If

      call 'GDI32.DeleteObject' D$HandCursorHandle
      call 'USER32.DestroyWindow' D@Addressee

      .Else_If D@Message = &WM_DESTROY
           call 'User32.PostQuitMessage' 0

      .Else
          popad
          call 'User32.DefWindowProcA' D@Addressee, D@Message, D@wParam, D@lParam
          ExitP

      .End_If

      popad | mov eax &FALSE

EndP
____________________________________________________________________________________________

; Here is our hyperlink procedure.
; The button is basically a child window and now
; we can receive any message a parent window would receive.
 
Proc HyperlinkProc:
    Arguments @hWnd @Message @wParam @lParam

    pushad
    .If D@Message = &WM_MOUSEMOVE

        ; the IE 3+ version
        ; We call this here, because everytime the app receive a
        ; MOUSELEAVE or MOUSEHOVER it ends MouseTracking.
        call 'COMCTL32._TrackMouseEvent' TRACKMOUSEEVENT

    .Else_If D@Message = &WM_MOUSEHOVER
    
        ; OK we are *hovering* over the control
        ; lets make our cursor into a hand.
        call 'USER32.SetCursor' D$HandCursorHandle

        ; Set our hovering state as TRUE
        If D$Hovering = &FALSE
            mov D$Hovering &TRUE
        End_If

        ; We must call this or it will not redraw the control
        ; and the drawing will not occur.
        call 'USER32.InvalidateRect' D@hWnd 0 &TRUE
        ; Ensure a WM_PAINT is sent
        call 'USER32.UpdateWindow' D@hWnd

    .Else_If D@Message = &WM_MOUSELEAVE

        ; Our cursor left, boohoo!
        ; Set it back to FALSE
        If D$Hovering = &TRUE
            mov D$Hovering &FALSE
        End_If

        ; We must call this or it will not redraw the control
        ; and the drawing will not occur.
        call 'USER32.InvalidateRect' D@hWnd 0 &TRUE
        ; Ensure a WM_PAINT is sent
        call 'USER32.UpdateWindow' D@hWnd
        
    .Else_If D@Message = &WM_LBUTTONUP

        ; the user clicked our hyperlink, now we
        ; finish the charade by loading a url in the
        ; systems default handler for URLs
        call 'SHELL32.ShellExecuteA' D$WindowHandle,
                                      {"open" 0},
                                      {"http://www.rosasm.org" 0},
                                      0,
                                      0,
                                      &SW_SHOWNORMAL
    .End_If

    popad

    ; pass the messages along to the old procedure
    call 'USER32.CallWindowProcA' D$OldHyperlinkProc,
                                  D@hWnd,
                                  D@Message,
                                  D@wParam,
                                  D@lParam

EndP

____________________________________________________________________________________________

Proc DrawTheHyperLink:
    ; Handy macros for readability
    Arguments @DIS_PTR
    Uses ebx,esi

    ; This (RC) local will hold a the address of the RC struct passed
    ; via the wParam. Later we need to pass the structure to API.
    Local @RC

    ; Move the base address of the passed struct into ebx for later access.
    mov ebx D@DIS_PTR

    ; Ok now we load into esi the address of the ownerdrawn control's RECT
    ; structure and back into our local.
    lea esi D$ebx+rcItem.leftDis ; D$base+displacement
    mov D@RC esi

    ; Ok here is where we set the color based on the state
    ; of the hyperlink.
    .If D$Hovering = 1
        RGB 0 0 255  ;Blue
    .Else_If D$Hovering = 0
        RGB 0 0 0    ;Black
    .End_If

        ; And then set the color
        call 'GDI32.SetTextColor' D$ebx+hdcDis eax

        ; DrawText needs the length of the text. You are not required to
        ; null terminate it. You could just hard code a number if you wish.
        call 'KERNEL32.lstrlenA' BTEXT

        ; Now Draw it :)
        call 'USER32.DrawTextA' D$ebx+hdcDis BTEXT eax,
                                D@RC &DT_CENTER+&DT_VCENTER+&DT_SINGLELINE

EndP
